#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "audioinputdlg.h"
#include "videoinputdlg.h"
#include "setupdlg.h"
#include "videoqualitydlg.h"
#include "filerecorddlg.h"
#include "sharerecorddlg.h"


MainWindow*	g_pMainwindow = NULL;

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (uintptr_t)pUserData;

    g_pMainwindow->str_info[i].sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (uintptr_t)pUserData;

    g_pMainwindow->str_info[i].sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ULONG i = (uintptr_t)pUserData;

    qDebug("format changed Detecte \n");

    CHAR strVideoInput[ 64 ] = { 0 };

    CHAR strAudioInput[ 64 ] = { 0 };

    CHAR strFrameType[ 64 ] = { 0 };

    g_pMainwindow->m_nVideoWidth[ i ] = nVideoWidth;

    g_pMainwindow->m_nVideoHeight[ i ] = nVideoHeight;

    g_pMainwindow->m_bVideoIsInterleaved[ i ] = bVideoIsInterleaved;

    g_pMainwindow->m_dVideoFrameRate[ i ] = dVideoFrameRate;

    g_pMainwindow->m_nAudioChannels[ i ] = nAudioChannels;

    g_pMainwindow->m_nAudioBitsPerSample[ i ] = nAudioBitsPerSample;

    g_pMainwindow->m_nAudioSampleFrequency[ i ] = nAudioSampleFrequency;

    g_pMainwindow->m_nVideoInput[ i ] = nVideoInput;

    g_pMainwindow->m_nAudioInput[ i ] = nAudioInput;

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    g_pMainwindow->str_info[i].sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ , VIDEO INPUT : %s , AUDIO INPUT : %s",
                                       nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample,
                                       nAudioSampleFrequency, strVideoInput, strAudioInput);

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (uintptr_t)pUserData;

    if( g_pMainwindow->m_bIsShareRecord && g_pMainwindow->m_nShareRecordCH == i )
    {
        QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYPE_YV12, g_pMainwindow->m_nVideoWidth[ i ], g_pMainwindow->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen, dSampleTime);
    }

    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (uintptr_t)pUserData;

    if( g_pMainwindow->m_bIsShareRecord && g_pMainwindow->m_nShareRecordCH == i )
    {
        QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen, dSampleTime );
    }

    return QCAP_RT_OK;
}


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->resize(960, 540);

    this->setFixedSize(960, 540);

    ui->frame_1->move(0,0);

    ui->frame_2->move(this->width()/2,0);

    ui->frame_3->move(0,this->height()/2);

    ui->frame_4->move(this->width()/2,this->height()/2);

    ui->frame_1->resize(this->width()/2,this->height()/2);

    ui->frame_2->resize(this->width()/2,this->height()/2);

    ui->frame_3->resize(this->width()/2,this->height()/2);

    ui->frame_4->resize(this->width()/2,this->height()/2);

    path = QCoreApplication::applicationDirPath();

    m_setupdlg = new setupdlg(this);

    m_setupdlg->show();

    g_pMainwindow = this;


    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_VideoInput()), this, SLOT(SetUpDialogSlot_VideoInput()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_AudioInput()), this, SLOT(SetUpDialogSlot_AudioInput()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_VideoQuality()), this, SLOT(SetUpDialogSlot_VideoQuality()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_FileRecord()), this, SLOT(SetUpDialogSlot_FileRecord()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_ShareRecord()), this, SLOT(SetUpDialogSlot_ShareRecord()));

    connect( m_setupdlg, SIGNAL(SetUpDialjogSignal_DestroyAP()), this, SLOT(SetUpDialogSlot_DestroyAP()));

    connect( m_setupdlg, SIGNAL(SetUpDialogSignal_DisplayWindow(int)), this, SLOT(SetUpDialogSlot_DisplayWindow(int)));


    //INITIALIZE MEMBER VARIABLES

    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        m_hVideoDevice[ i ] = NULL;

        m_hCloneCapDev[ i ] = NULL;

        m_nVideoWidth[ i ] = 0;

        m_nVideoHeight[ i ] = 0;

        m_bVideoIsInterleaved[ i ] = 0;

        m_dVideoFrameRate[ i ] = 0;

        m_nAudioChannels[ i ] = 0;

        m_nAudioBitsPerSample[ i ] = 0;

        m_nAudioSampleFrequency[ i ] = 0;

        m_nVideoInput[ i ] = QCAP_INPUT_TYPE_SDI;

        m_nAudioInput[ i ] = QCAP_INPUT_TYPE_EMBEDDED_AUDIO;

    }

    m_bIsShareRecord = false;

    m_nShareRecordCH = 0;

    HwInitialize();
}

MainWindow::~MainWindow()
{
    HwUninitialize();

    delete ui;
}


void MainWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE    
    char CapDevName[16] = "MZ0380 PCI";

    QCAP_CREATE( CapDevName, 0, (HWND)ui->frame_1->winId(), &m_hVideoDevice[0], TRUE);

    QCAP_CREATE( CapDevName, 1, (HWND)ui->frame_2->winId(), &m_hVideoDevice[1], TRUE);

    QCAP_CREATE( CapDevName, 2, (HWND)ui->frame_3->winId(), &m_hVideoDevice[2], TRUE);

    QCAP_CREATE( CapDevName, 3, (HWND)ui->frame_4->winId(), &m_hVideoDevice[3], TRUE);


    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[i], on_process_no_signal_detected, (PVOID)i );

        QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[i], on_process_signal_removed, (PVOID)i );

        QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[i], on_process_format_changed, (PVOID)i );

        QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[i], on_video_preview_callback, (PVOID)i );

        QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[i], on_process_preview_audio_buffer, (PVOID)i );

        QCAP_SET_VIDEO_INPUT( m_hVideoDevice[i], QCAP_INPUT_TYPE_SDI );

        QCAP_SET_AUDIO_INPUT( m_hVideoDevice[i], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

        QCAP_RUN( m_hVideoDevice[i] );
    }

    QCAP_SET_AUDIO_SOUND_RENDERER(m_hVideoDevice[0], 0);

}

void MainWindow::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        if( m_hVideoDevice[i] ) {

            QCAP_STOP( m_hVideoDevice[i] );

            QCAP_DESTROY( m_hVideoDevice[i] );

            m_hVideoDevice[i] = NULL;
        }
    }

}

void MainWindow::SetUpDialogSlot_VideoInput()
{
    VideoInputDlg video_input(this);

    video_input.exec();
}

void MainWindow::SetUpDialogSlot_AudioInput()
{
    AudioInputDlg audio_input(this);

    audio_input.exec();
}

void MainWindow::SetUpDialogSlot_Snapshot_BMP()
{
    QString bmp_path = path + QString("/Snapshot_BMP.bmp");

    QByteArray bmp_path_ByteArray = bmp_path.toLocal8Bit();

    CHAR* psz = bmp_path_ByteArray.data();

    //QCAP_SNAPSHOT_BMP( m_hVideoDevice[ m_nCurChannel ], psz );
}

void MainWindow::SetUpDialogSlot_Snapshot_JPG()
{
    QString jpg_path = path + QString("/Snapshot_JPG.jpg");

    QByteArray jpg_path_ByteArray =jpg_path.toLocal8Bit();

    CHAR* psz = jpg_path_ByteArray.data();

    //QCAP_SNAPSHOT_JPG( m_hVideoDevice[ m_nCurChannel ], psz, 100 );
}

void MainWindow::SetUpDialogSlot_VideoQuality()
{
    VideoQualityDlg vodeo_quality(this);

    vodeo_quality.exec();
}

void MainWindow::SetUpDialogSlot_FileRecord()
{
    FileRecordDlg FileRecord(this);

    FileRecord.exec();
}

void MainWindow::SetUpDialogSlot_ShareRecord()
{
    ShareRecordDlg ShareRecord(this);

    ShareRecord.exec();
}

void MainWindow::SetUpDialogSlot_DisplayWindow(int channel_id)
{
    ui->frame_1->close();

    ui->frame_2->close();

    ui->frame_3->close();

    ui->frame_4->close();

    switch (channel_id) {

        case 0:

            ui->frame_1->move(0,0);

            ui->frame_2->move(this->width()/2,0);

            ui->frame_3->move(0,this->height()/2);

            ui->frame_4->move(this->width()/2,this->height()/2);

            ui->frame_1->resize(this->width()/2,this->height()/2);

            ui->frame_2->resize(this->width()/2,this->height()/2);

            ui->frame_3->resize(this->width()/2,this->height()/2);

            ui->frame_4->resize(this->width()/2,this->height()/2);

            ui->frame_1->show();

            ui->frame_2->show();

            ui->frame_3->show();

            ui->frame_4->show();

            break;

        case 1:

            ui->frame_1->move(0,0);

            ui->frame_1->resize(this->width(),this->height());

            ui->frame_1->show();

            m_nCurChannel = 0;

            break;

        case 2:

            ui->frame_2->move(0,0);

            ui->frame_2->resize(this->width(),this->height());

            ui->frame_2->show();

            m_nCurChannel = 1;

            break;

        case 3:

            ui->frame_3->move(0,0);

            ui->frame_3->resize(this->width(),this->height());

            ui->frame_3->show();

            m_nCurChannel = 2;

            break;

        case 4:

            ui->frame_4->move(0,0);

            ui->frame_4->resize(this->width(),this->height());

            ui->frame_4->show();

            m_nCurChannel = 3;

            break;

        default:
            break;
    }
}

